#
# Sample spec file using the subpackage infrastructure.
#
# Copyright (c) 2019 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#
# needssslcertforbuild

# To be defined by user
%define build_flavor default
# variant includes dash: %%define variant -azure
%define variant %{nil}
%define subpackage base
%define extrasummary base modules
%define extradescription This package contains only the base modules, required in all installs.

%define misc_modules button edd iscsi_ibft i6300esb

%define virtio_modules virtio_blk virtio-rng virtio_console virtio-gpu \
virtio_net virtio_scsi virtio virtio_balloon virtio_input virtio_mmio \
virtio_pci virtio_ring

%define xen_modules xen-blkfront xen-kbdfront xen-netfront xen-fbfront xenblk xennet

%define vmware_modules vmw_balloon vmw_vmci vmxnet3 vmw_pvscsi vmw_vsock_vmci_transport

%define hyperv_modules hid-hyperv hv_balloon hv_utils \
hv_vmbus hyperv-keyboard hv_netvsc hv_storvsc scsi_transport_fc hyperv_fb

%define net_drivers  8390 ne2k-pci tulip e100 e1000 e1000e 8139cp 8139too

%define scsi_modules scsi_transport_iscsi sd_mod sg sr_mod st scsi_mod

%define block_drivers loop dm-mod ahci ata_piix mptsas mptspi BusLogic sym53c8xx aam53c974

%define usb_modules usb-common usbcore ehci-hcd ehci-pci ohci-hcd ohci-pci uhci-hcd \
xhci-hcd xhci-pci typec_ucsi ucsi_acpi typec ums-alauda ums-cypress ums-datafab \
ums-eneub6250 ums-freecom ums-isd200 ums-jumpshot ums-karma ums-onetouch \
ums-realtek ums-sddr09 ums-sddr55 ums-usbat usb-storage

%define filesystems autofs4 btrfs ext4 vfat isofs jbd2 mbcache nfsv2 nfsv3 nfsv4 overlay xfs \
        nls_cp437 nls_iso8859-1

%define networking tun veth bridge arp_tables arpt_mangle arptable_filter \
ip_tables ipt_ECN ipt_MASQUERADE ipt_REJECT ipt_SYNPROXY ipt_ah ipt_rpfilter \
iptable_filter iptable_mangle iptable_nat iptable_raw iptable_security \
nf_conntrack_ipv4 nf_defrag_ipv4 nf_dup_ipv4 nf_log_arp nf_log_ipv4 nf_nat_h323 \
nf_nat_ipv4 nf_nat_masquerade_ipv4 nf_nat_pptp nf_nat_proto_gre \
nf_nat_snmp_basic ip6_tables ip6t_MASQUERADE ip6t_NPT ip6t_REJECT ip6t_SYNPROXY \
ip6t_ah ip6t_eui64 ip6t_frag ip6t_hbh ip6t_ipv6header ip6t_mh ip6t_rpfilter \
ip6t_rt ip6table_filter ip6table_mangle ip6table_nat ip6table_raw \
ip6table_security nf_conntrack_ipv6 nf_defrag_ipv6 nf_dup_ipv6 nf_log_ipv6 \
nf_nat_ipv6 nf_nat_masquerade_ipv6 ip_set ip_set_bitmap_ip ip_set_bitmap_ipmac \
ip_set_bitmap_port ip_set_hash_ip ip_set_hash_ipmark ip_set_hash_ipport \
ip_set_hash_ipportip ip_set_hash_ipportnet ip_set_hash_mac ip_set_hash_net \
ip_set_hash_netiface ip_set_hash_netnet ip_set_hash_netport \
ip_set_hash_netportnet ip_set_list_set nf_conntrack nf_conntrack_amanda \
nf_conntrack_broadcast nf_conntrack_ftp nf_conntrack_h323 nf_conntrack_irc \
nf_conntrack_netbios_ns nf_conntrack_netlink nf_conntrack_pptp \
nf_conntrack_proto_gre nf_conntrack_sane nf_conntrack_sip nf_conntrack_slp \
nf_conntrack_snmp nf_conntrack_tftp nf_log_common nf_nat nf_nat_amanda \
nf_nat_ftp nf_nat_irc nf_nat_redirect nf_nat_sip nf_nat_tftp nf_synproxy_core \
nfnetlink nfnetlink_acct nfnetlink_cthelper nfnetlink_cttimeout nfnetlink_log \
nfnetlink_queue x_tables xt_AUDIT xt_CHECKSUM xt_CLASSIFY xt_CONNSECMARK xt_CT \
xt_DSCP xt_HL xt_HMARK xt_IDLETIMER xt_LED xt_LOG xt_NETMAP xt_NFLOG xt_NFQUEUE \
xt_RATEEST xt_REDIRECT xt_SECMARK xt_TCPMSS xt_TCPOPTSTRIP xt_TEE xt_TPROXY \
xt_TRACE xt_addrtype xt_bpf xt_cgroup xt_cluster xt_comment xt_connbytes \
xt_connlabel xt_connlimit xt_connmark xt_conntrack xt_cpu xt_dccp xt_devgroup \
xt_dscp xt_ecn xt_esp xt_hashlimit xt_helper xt_hl xt_ipcomp xt_iprange xt_l2tp \
xt_length xt_limit xt_mac xt_mark xt_multiport xt_nat xt_nfacct xt_osf xt_owner \
xt_physdev xt_pkttype xt_policy xt_quota xt_rateest xt_realm xt_recent xt_sctp \
xt_set xt_socket xt_state xt_statistic xt_string xt_tcpmss xt_tcpudp xt_time \
xt_u32 af_packet

%define modules %usb_modules %net_drivers %scsi_modules %block_drivers \
                %hyperv_modules %virtio_modules %vmware_modules %xen_modules \
                %networking %filesystems %misc_modules

# Reasonable defaults that might be overriden if needed
%define kernel_package_name kernel-%build_flavor
%define package_name %kernel_package_name-%subpackage
%define url %(rpm -q --qf '%%{URL}' %kernel_package_name)
%define group %(rpm -q --qf '%%{GROUP}' %kernel_package_name)
%define summary %(rpm -q --qf '%%{SUMMARY}' %kernel_package_name) - %extrasummary

Name:           %package_name
BuildRequires:  %kernel_package_name
BuildRequires:  %kernel_package_name-devel
BuildRequires:  kernel-subpackage-macros
Summary:        %summary
URL:            %url
Group:          %group
License:        GPL-2.0-only

# Internal stuff begins
%define rpm_kver %(rpm -q --qf '%%{VERSION}' %kernel_package_name)
%define rpm_krel %(rpm -q --qf '%%{RELEASE}' %kernel_package_name)
Version:        %rpm_kver
Release:        %rpm_krel.<RELEASE>

%define scriptdir /usr/lib/rpm/kernel
%include %scriptdir/kernel-subpackage-spec
